import java.awt.event.*;
class KlickEmpfaenger implements ActionListener{
  private Datenbanktest dt;
  DatabaseConnector db1, db2;     
  List<Leser> listeVielleser;
  List<AG> agListe;
  Leser neuLeser;
  
  public KlickEmpfaenger(Datenbanktest d){
    dt=d;
    db1=new DatabaseConnector("127.0.0.1", 3306,"./lib/bib.db", "", "");     
    db2=new DatabaseConnector("127.0.0.1", 3306,"./lib/AGVerwaltung.db", "", "");
  }
  
  public void beenden(){
    db1.close();
    db2.close();
  }
  
  public List<Leser> ermittleListeVielleser(){
    List<Leser> li; 
    db1.executeStatement("SELECT Nachname, Vorname, Klasse, Anzahl From Leser, (Select * FROM (SELECT benutzer_id AS ID, COUNT(ausleih_id) AS Anzahl FROM Ausleihe GROUP By benutzer_id )) WHERE benutzer_id=ID AND Anzahl>8 ORDER By Anzahl DESC");
    QueryResult q=db1.getCurrentQueryResult();
    String[][] daten=q.getData();
    String f=db1.getErrorMessage();
    dt.setAnzeige(f);
    li=new List<Leser>();
    for(int i=0; i<q.getRowCount();i++){
      neuLeser=new Leser(daten[i][0],daten[i][1], daten[i][2],daten[i][3]);
      li.append(neuLeser);
    }
    return li;
  }
  
  public List<AG> anzahlenLeserInAGUndLeserListe(List<Leser> li){
    List<AG> agLi;
    agLi=null; //bitte modifizieren
    return agLi;
  }
  
  public void ausgabe(List<AG> agLi){
    String aus="";         
    agLi.toFirst();
    while (agLi.hasAccess()) { 
      aus=aus+ agLi.getContent().name()+" "+agLi.getContent().anzahlVielleser(); 
      aus=aus+"\n";
      agLi.next();
    } // end of while           
    dt.setAnzeige(aus);
  }
  
  public void actionPerformed(ActionEvent e) {
    if(e.getActionCommand().equals("Ende")){
      beenden();
    }          
    if (e.getActionCommand().equals("Liste ausgeben")){
      listeVielleser=ermittleListeVielleser();
      agListe=anzahlenLeserInAGUndLeserListe(listeVielleser);
      ausgabe(agListe);         
    }
  }
}
